
#include "platform.h"
#include "5_7font.h"
#include "macro.h"
#include "headfile.h"

#define ASC_COUNT			95	//总字符数
#define ASC_START			32	//起始字符
#define ASC_WIDTH			8	//每个字符的宽度(像素)
#define ASC_HEIGHT			8	//每个字符的高度(像素)
#define ROW_SPACE			1	//行间距(像素)
#define COL_SPACE			1	//列间距(像素)
#define TAB_SPACE_NUM		4	//每个TAB转换成几个空格输出

#define CN_CHAR_HEIGHT		10	//中文字符高度
#define CN_CHAR_WIDTH		10	//中文字符宽度

unsigned short* vram_buffer=((unsigned short*)0x6800000);

//////////////////////////////////////////////////////////////////////////
//putpixel()
//画像素
//////////////////////////////////////////////////////////////////////////
inline void putpixel(int y,int x,unsigned int color,unsigned short* buffer/*=NULL*/)
{
	*(buffer + y*SCREEN_WIDTH + x)=color;
}

//////////////////////////////////////////////////////////////////////////
//DrawASC()
//显示单个字符
//////////////////////////////////////////////////////////////////////////
int DrawASC(int nRow,int nCol,int nIndex,unsigned int color,unsigned short* buffer)
{
	if( nIndex == ' ' - ASC_START ) //如果是空格,不画,直接返回3,也就是说,原来这个位置有内容,也不进行擦除
		return 3;
		
	int nWidth=0;
	if(nIndex > ASC_COUNT || nIndex < 0)
		return nWidth;
	unsigned char * pLocation=nAsciiDot+nIndex*ASC_WIDTH;
	unsigned char * ptemp=0;
	int i=0,j=0;
	int row=nRow,col=nCol;
	
	for(i=0; i<ASC_HEIGHT; i++)
	{
		ptemp=pLocation+i;
		for(j=0; j<ASC_WIDTH; j++)
		{
			if( (*ptemp)&BIT(ASC_WIDTH-j-1) )
			{
				putpixel(row,col,color,buffer);
				if( j > nWidth)
					nWidth=j;
			}
			//else //背景色
			//	putpixel(row,col,RGB15(0,31,0)|BIT(15),buffer);
			col++;
		}
		col=nCol;
		row++;
	}
	if(	nIndex == '!'-ASC_START ||
			nIndex == ','-ASC_START ||
			nIndex == '.'-ASC_START ||
			nIndex == '?'-ASC_START ||
			nIndex == '"'-ASC_START ||
			nIndex == ';'-ASC_START ||
			nIndex == ':'-ASC_START )
			return ASC_WIDTH;
	else
		return nWidth+1;
}

//////////////////////////////////////////////////////////////////////////
typedef char * va_list;
#define _INTSIZEOF(n)   ((sizeof(n)+sizeof(int)-1)&~(sizeof(int) - 1) )
#define va_start(ap,v) ( ap = (va_list)&v + _INTSIZEOF(v) )
#define va_arg(ap,t) ( *(t *)((ap += _INTSIZEOF(t)) - _INTSIZEOF(t)) )
#define va_end(ap)    ( ap = (va_list)0 )

const char *digits="0123456789abcdef";
char numbers[68];

static char print_buf[1024];

#define FORMAT_TYPE_MASK	0xff00
#define FORMAT_TYPE_SIGN_BIT	0x0100
#define FORMAT_TYPE_NONE	0x000
#define FORMAT_TYPE_CHAR	0x100
#define FORMAT_TYPE_UCHAR	0x200
#define FORMAT_TYPE_SHORT	0x300
#define FORMAT_TYPE_USHORT	0x400
#define FORMAT_TYPE_INT		0x500
#define FORMAT_TYPE_UINT	0x600
#define FORMAT_TYPE_LONG	0x700
#define FORMAT_TYPE_ULONG	0x800
#define FORMAT_TYPE_STR		0xd00
#define FORMAT_TYPE_PTR		0x900
#define FORMAT_TYPE_SIZE_T	0xb00

#define FORMAT_TYPE(x)	((x)&FORMAT_TYPE_MASK)
#define SET_FORMAT_TYPE(x,t)	do{\
(x)&=~FORMAT_TYPE_MASK;(x)|=(t);\
}while(0)
#define FORMAT_SIGNED(x)	((x)&FORMAT_TYPE_SIGN_BIT)

#define FORMAT_FLAG_MASK	0xffff0000
#define FORMAT_FLAG_SPACE	0x10000
#define FORMAT_FLAG_ZEROPAD	0x20000
#define FORMAT_FLAG_LEFT	0x40000
#define	FORMAT_FLAG_WIDTH	0x100000

#define FORMAT_FLAG(x)	((x)&FORMAT_FLAG_MASK)
#define SET_FORMAT_FLAG(x,f)	((x)|=(f))

#define FORMAT_BASE_MASK	0xff
#define FORMAT_BASE_O		0x08
#define FORMAT_BASE_X		0x10
#define FORMAT_BASE_D		0x0a
#define FORMAT_BASE_B		0x02

#define FORMAT_BASE(x)	(FORMAT_BASE_MASK&(x))
#define SET_FORMAT_BASE(x,t)	do{(x)&=~FORMAT_BASE_MASK;(x)|=(t);}while(0)

/*function my_divmod is taken from libgcc sourcecode (udivmodsi4.c),
url: http://gcc.gnu.org/git/?p=gcc.git;a=blob;f=libgcc/udivmodsi4.c
2 usages: 
	(1) mod: to get x%y, call my_divmod(x,y,1);
	(2) div: to get x/y, call my_divmod(x,y,0);
	note: both x and y are integers.
*/
unsigned int my_divmod(unsigned int num, unsigned int den, int modwanted)
{
  unsigned int bit = 1;
  unsigned int res = 0;

  while (den < num && bit && !(den & (1L<<31)))
    {
      den <<=1;
      bit <<=1;
    }
  while (bit)
    {
      if (num >= den)
        {
          num -= den;
          res |= bit;
        }
      bit >>=1;
      den >>=1;
    }
  if (modwanted) return num;
  return res;
}

#define do_div(n,base) ({ \
	int __res; \
	__res = my_divmod((unsigned int) n, (unsigned int) base, 1); \
	n = my_divmod((unsigned int) n, (unsigned int) base, 0); \
	__res; })

/*
#define do_div(n,base) ({ \
	int __res; \
	__res = ((unsigned int) n) % (unsigned int) base; \
	n = ((unsigned int) n) / (unsigned int) base; \
	__res; })
*/

#define CLEAR_ONE_LINE memset32(vram_buffer+(yy<<8),0,CN_CHAR_HEIGHT<<7)
static int xx,yy;

void __put_char(char *p,int num)
{
	//int xx=0, yy=0;
	while(*p&&num--)
	{
		switch(*p)
		{
		case '\n':
			xx=0;
			yy+=(CN_CHAR_HEIGHT+ROW_SPACE);
			CLEAR_ONE_LINE;//当屏幕最后一行遇到‘\n’，会清掉屏幕最上面一行
			break;
		case '\t'://加上自己的代码,比如输入4个空格
		{
			if(xx < SCREEN_WIDTH)
			{
				xx=xx+TAB_SPACE_NUM*(CN_CHAR_WIDTH+ROW_SPACE);
				if(xx >= SCREEN_WIDTH)
				{
					yy+=(CN_CHAR_HEIGHT+ROW_SPACE);
					xx=0;
				}
			}
			break;
		}
		default:
			xx+=DrawASC(yy+(CN_CHAR_HEIGHT-ASC_HEIGHT),xx,(*p)-ASC_START,0x7fff,vram_buffer);
			xx+=COL_SPACE;
			break;
		}//switch
		
		if(xx+CN_CHAR_WIDTH > SCREEN_WIDTH || yy+(CN_CHAR_HEIGHT+ROW_SPACE)>SCREEN_HEIGHT)
		{
			yy+=(CN_CHAR_HEIGHT+ROW_SPACE);
			if(yy+CN_CHAR_HEIGHT>SCREEN_HEIGHT)
				yy = 0;
			CLEAR_ONE_LINE;
			xx=0;
		}	
		p++;
	};
}

void * memcpy(void * dest,const void *src,unsigned int count)
{
	char *tmp = (char *) dest, *s = (char *) src;
	while (count--)
		*tmp++ = *s++;
	return dest;
}

char *number(char *str, int num,int base,unsigned int flags){
	int i=0;
	int sign=0;

	if(FORMAT_SIGNED(flags)&&(signed int)num<0){
		sign=1;
		num=~num+1;
	}

	do{
		numbers[i++]=digits[do_div(num,base)];
	}while(num!=0);
	

	if(FORMAT_BASE(flags)==FORMAT_BASE_O){
		numbers[i++]='0';
	}else if(FORMAT_BASE(flags)==FORMAT_BASE_X){
		numbers[i++]='x';
		numbers[i++]='0';
	}else if(FORMAT_BASE(flags)==FORMAT_BASE_B){
		numbers[i++]='b';
		numbers[i++]='0';
	}
	if(sign)
		numbers[i++]='-';

	while (i-- > 0)
			*str++ = numbers[i];
	return str;
}

int format_decode(const char *fmt,unsigned int *flags){
	const char *start = fmt;

	*flags &= ~FORMAT_TYPE_MASK;
	*flags |= FORMAT_TYPE_NONE;
	for (; *fmt ; ++fmt) {
		if (*fmt == '%')
		break;
	}

	if (fmt != start || !*fmt)
		return fmt - start;

	do{
		fmt++;
		switch(*fmt){
			case 'l':
				SET_FORMAT_FLAG(*flags,FORMAT_FLAG_WIDTH);
				break;
			default:
				break;
		}
	}while(0);
	
	SET_FORMAT_BASE(*flags,FORMAT_BASE_D);
	switch (*fmt) {
		case 'c':
			SET_FORMAT_TYPE(*flags,FORMAT_TYPE_CHAR);
			break;

		case 's':
			SET_FORMAT_TYPE(*flags,FORMAT_TYPE_STR);
			break;

		case 'o':
			SET_FORMAT_BASE(*flags,FORMAT_BASE_O);
			SET_FORMAT_TYPE(*flags,FORMAT_TYPE_UINT);
			break;

		case 'x':
		case 'X':
			SET_FORMAT_BASE(*flags,FORMAT_BASE_X);
			SET_FORMAT_TYPE(*flags,FORMAT_TYPE_UINT);
			break;

		case 'd':
		case 'i':
			SET_FORMAT_BASE(*flags,FORMAT_BASE_D);
			SET_FORMAT_TYPE(*flags,FORMAT_TYPE_INT);
			break;
		case 'u':
			SET_FORMAT_BASE(*flags,FORMAT_BASE_D);
			SET_FORMAT_TYPE(*flags,FORMAT_TYPE_UINT);
			break;
			
		case 'b':
		case 'B':
			SET_FORMAT_BASE(*flags,FORMAT_BASE_B);
			SET_FORMAT_TYPE(*flags,FORMAT_TYPE_UINT);
			break;			

	default:
		break;
	}
	return ++fmt-start;
}

int vsnprintf(char *buf, int size, const char *fmt, va_list args){
	int num;
	char *str, *end, c,*s;
	int read;
	unsigned int spec=0;

	str = buf;
	end = buf + size;

	if (end < buf) {
		end = ((void *)-1);
		size = end - buf;
	}

	while (*fmt) {
		const char *old_fmt = fmt;

		read = format_decode(fmt, &spec);
		fmt += read;

		if((FORMAT_TYPE(spec))==FORMAT_TYPE_NONE){
			int copy = read;
			if (str < end) {
				if (copy > end - str)
					copy = end - str;
					memcpy(str, old_fmt, copy);
			}
			str += read;

		}else if(spec&FORMAT_FLAG_WIDTH){
			//do nothing
		}else if(FORMAT_TYPE(spec)==FORMAT_TYPE_CHAR){
			c = (unsigned char) va_arg(args, int);
			if (str < end)
				*str = c;
			++str;
		}else if(FORMAT_TYPE(spec)==FORMAT_TYPE_STR){
			s = (char *) va_arg(args, char *);
			while(str<end&&*s!='\0'){
				*str++=*s++;
			}
		}else{
			if(FORMAT_TYPE(spec)==FORMAT_TYPE_INT){
				num = va_arg(args, int);
			}else if(FORMAT_TYPE(spec)==FORMAT_TYPE_ULONG){
				num = va_arg(args, unsigned long);
			}else if(FORMAT_TYPE(spec)==FORMAT_TYPE_LONG){
				num = va_arg(args, long);
			}else if(FORMAT_TYPE(spec)==FORMAT_TYPE_SIZE_T){
				num = va_arg(args, int);
			}else if(FORMAT_TYPE(spec)==FORMAT_TYPE_USHORT){
				num = (unsigned short) va_arg(args, int);
			}else if(FORMAT_TYPE(spec)==FORMAT_TYPE_SHORT){
				num = (short) va_arg(args, int);
			}else{
				num = va_arg(args, unsigned int);
			}
				str=number(str,num,spec&FORMAT_BASE_MASK,spec);
		}
	}
	if (size > 0) {
		if (str < end)
			*str = '\0';
		else
			end[-1] = '\0';
	}
	return str-buf;
}

void printk(const char *fmt, ...)
{
	va_list args;
	unsigned int i;

	va_start (args, fmt);
	i = vsnprintf (print_buf, sizeof(print_buf),fmt, args);
	va_end (args);

	__put_char (print_buf,i);
}
