#ifndef _PLATFORM_H_
#define _PLATFORM_H_

#define REG_IME			(*(volatile unsigned int*)0x04000208)
#define REG_IE			(*(volatile unsigned int*)0x04000210)
#define REG_IF			(*(volatile unsigned int*)0x04000214)
#define REG_KEYINPUT	(*(volatile unsigned short*)0x04000130)
#define REG_KEYCNT		(*(volatile unsigned short*)0x04000132)
#define WAIT_FLAGS		(*(volatile unsigned int*)0x0b003ffc)
#define	REG_DISPSTAT	(*(volatile unsigned short*)0x04000004)
#define REG_IPC_SYNC	(*(volatile unsigned short*)0x04000180)

#define SCREEN_WIDTH		256
#define SCREEN_HEIGHT		192

#define RGB15(r,g,b)  ((r)|((g)<<5)|((b)<<10))

//! LCD Status register bitdefines
#define	DISP_IN_VBLANK     1<<0 //!<	The display currently in a vertical blank.
#define	DISP_IN_HBLANK     1<<1 //!<	The display currently in a horizontal blank.
#define	DISP_YTRIGGERED    1<<2 //!<	Current scanline and %DISP_Y match.
#define	DISP_VBLANK_IRQ    1<<3 //!<	Interrupt on vertical blank.
#define	DISP_HBLANK_IRQ    1<<4 //!<	Interrupt on horizontal blank.
#define	DISP_YTRIGGER_IRQ  1<<5  //!<	Interrupt when current scanline and %DISP_Y match.

#define	IPC_SYNC_IRQ_ENABLE		1<<14
#define	IPC_SYNC_IRQ_REQUEST	1<<13

//volatile unsigned int* vram_buffer ((unsigned short*)0x6800000)

#define	IRQ_VBLANK			1<<0 		/*!< vertical blank interrupt mask */
#define	IRQ_HBLANK			1<<1 		/*!< horizontal blank interrupt mask */
#define	IRQ_VCOUNT			1<<2 		/*!< vcount match interrupt mask */
#define	IRQ_TIMER0			1<<3 		/*!< timer 0 interrupt mask */
#define	IRQ_TIMER1			1<<4 		/*!< timer 1 interrupt mask */
#define	IRQ_TIMER2			1<<5 		/*!< timer 2 interrupt mask */
#define	IRQ_TIMER3			1<<6 		/*!< timer 3 interrupt mask */
#define	IRQ_NETWORK			1<<7 		/*!< serial interrupt mask */
#define	IRQ_DMA0			1<<8 		/*!< DMA 0 interrupt mask */
#define	IRQ_DMA1			1<<9 		/*!< DMA 1 interrupt mask */
#define	IRQ_DMA2			1<<10 	/*!< DMA 2 interrupt mask */
#define	IRQ_DMA3			1<<11 	/*!< DMA 3 interrupt mask */
#define	IRQ_KEYS			1<<12 	/*!< Keypad interrupt mask */
#define	IRQ_CART			1<<13 	/*!< GBA cartridge interrupt mask */
#define	IRQ_IPC_SYNC		1<<16 	/*!< IPC sync interrupt mask */
#define	IRQ_FIFO_EMPTY		1<<17 	/*!< Send FIFO empty interrupt mask */
#define	IRQ_FIFO_NOT_EMPTY	1<<18 	/*!< Receive FIFO not empty interrupt mask */
#define	IRQ_CARD			1<<19 	/*!< interrupt mask DS Card Slot*/
#define	IRQ_CARD_LINE		1<<20 	/*!< interrupt mask */
#define	IRQ_GEOMETRY_FIFO	1<<21 	/*!< geometry FIFO interrupt mask */
#define	IRQ_LID				1<<22 	/*!< interrupt mask DS hinge*/
#define	IRQ_SPI				1<<23 	/*!< SPI interrupt mask */
#define	IRQ_WIFI			1<<24 	/*!< WIFI interrupt mask (ARM7)*/
#define	IRQ_ALL				(~0)		/*!< 'mask' for all interrupt */

#define _SYS_MEM_START		0x2000000
#define _SYS_MEM_LENGTH		0x400000	//4MB ewram

typedef void (* IntFn)(void);
void irqInit();
void irqSet(unsigned int mask, IntFn handler);
void irqEnable(unsigned int irq);

#define true  1
#define false 0

#endif //#ifdef _PLATFORM_H_
