
#include "macro.h"
#include "platform.h"
#include "driver.h"


// Display control registers
#define	REG_DISPCNT		(*(volatile unsigned int*)0x04000000)
#define	REG_DISPCNT_SUB	(*(volatile unsigned int*)0x04001000)

#define VRAM_A        ((unsigned short*)0x6800000)/*!< \brief pointer to vram bank A mapped as LCD*/
#define MODE_FB0   0x00020000 /* video display directly from VRAM_A in LCD mode */
#define VRAM_A_CR		(*(volatile unsigned char*)0x04000240)
#define VRAM_ENABLE		(1<<7)
#define VRAM_A_LCD		0					//!< maps vram a to lcd.
#define	REG_POWERCNT	*(volatile unsigned short*)0x4000304
#define PM_ARM9_DIRECT BIT(16)
#define POWER_SWAP_LCDS	 PM_ARM9_DIRECT | BIT(15)		//!<	Controls which screen should use the main core.

#define RGB15(r,g,b)  ((r)|((g)<<5)|((b)<<10))

void videoSetMode( unsigned int mode)  { REG_DISPCNT = mode; }
void vramSetBankA(int a) { VRAM_A_CR = VRAM_ENABLE | a; }
static inline void lcdMainOnBottom(void) { REG_POWERCNT &= ~POWER_SWAP_LCDS; }

inline void setPixel( int x, int y, int color ) {
    VRAM_A[x + y * 256] = color;
}

/////////////////////////////////////////////////////////////////////////////////////
// extern from as file
#include "headfile.h"

int xxx=98;
int x1,y1;




void circle( int mx, int my, int r, int color ) 
{
    int x = 0;
    int y = r;
    int d = 3 - 2 * r;

    while (x <= y) 
    {
        setPixel( mx  + x, my + y, color );
        setPixel( mx  - x, my + y, color );
        setPixel( mx  - x, my - y, color );
        setPixel( mx  + x, my - y, color );
        setPixel( mx  + y, my + x, color );
        setPixel( mx  - y, my + x, color );
        setPixel( mx  - y, my - x, color );
        setPixel( mx  + y, my - x, color );

        if (d < 0) 
        {
            d = d + 4 * x + 6;
        } 
        else 
        {
            d = d + 4 * ( x - y ) + 10;
            y --;
        }
        x++;
    }
}

int gcMain(int argc, char** argv) 
{
	int i=0;
	int j=0;
    videoSetMode(MODE_FB0);
    vramSetBankA(VRAM_A_LCD);
    lcdMainOnBottom();
/*
	REG_DISPCNT = MODE_FB0;
	VRAM_A_CR = VRAM_ENABLE | VRAM_A_LCD;
	REG_POWERCNT &= ~POWER_SWAP_LCDS;
*/	

	
/*
	memset16(VRAM_A,RGB15(31,0,0),256*80);
	for(i=1; i<=5; i++)
		circle(40*i,40,35,RGB15(0,0,31));
	memset16(VRAM_A+256*80,RGB15(0,31,0),256*32);
	memcpy32(VRAM_A+256*112,VRAM_A,256*80/2);
	
	memset32((unsigned int*)VRAM_A+256*2, 0, 128);
*/	
	memset32((unsigned int*)VRAM_A, 0, 256*192*2/4);
	
	char a[20]="[[hello world]]";
	int b=735;
	double c=13.78;
	printk("string: %s, integer: %d, oct: %o, hex: %x, bin: %b, xx yy: %d %d",a,b,b,b,b,x1,y1);
	
	typedef void (*func)(void);
	/*
	REG_IME = 0;
	//REG_IE |= BIT(12)|0x1;
	REG_IF = IRQ_ALL;
	*((volatile unsigned int*)0x0b003ffc) = (unsigned int)(__vector_irq);//(common_irq_handler);//
	//REG_DISPSTAT |= DISP_VBLANK_IRQ ;
	//REG_IE |= IRQ_VBLANK;
	REG_IE |= IRQ_KEYS;
	REG_KEYCNT = 0x4003;
	REG_IME=1;
	*/
	//REG_KEYCNT = 0x4003;
	REG_KEYCNT = 0x43ff;
	irqInit();
	irqSet(IRQ_KEYS, common_irq_handler);
	irqSet(IRQ_VBLANK, vblank_irq_handler);
	//	irqSet(1<<13, common_irq_handler);
		//	irqSet(1<<19, common_irq_handler);
			//	irqSet(1<<20, common_irq_handler);
	irqEnable(IRQ_KEYS/*|IRQ_VBLANK*/);
	
	init_page_map();
	kmalloc_init();
	char *p = (char*)kmalloc(27);
	memset(p,0,27);
	memset(p,'g',10);
	memset(p+10,'9',6);
	//kfree(p);
	printk("\n");
	
	for(i=0; i<999990; i++)
	{int a=99; a*=a;	}
	
	unsigned char* buf = (unsigned char*)kmalloc(513);
	if(!initall(buf))
	{
		printk("ERROR SD!\n");
	}
	
//	buf[0]='a';
//	buf[1]='b';
//	buf[2]='c';	
//	buf[10]='\0';

	printk("ok\n");
	for(i=0; i<50; i++)
		printk("%x,",buf[i]);
	
while(1)
{
	continue;
//	REG_IE |= BIT(12);
	int k=0;
	unsigned short int keyinput = REG_KEYINPUT;
	unsigned short int keycnt = REG_KEYCNT;	
	unsigned int ie1 = REG_IE;
	unsigned int if1 = REG_IF;  
	printk("[%b,%b]",keyinput,keycnt);
	printk("\n%x ",p);
	for(k=0; k<1000000; k++);
	printk("%s",p);
}
    return 0;
}
