@---------------------------------------------------------------------------------
@ DS processor selection
@---------------------------------------------------------------------------------
	.arch	armv5te
	.cpu	arm946e-s
@---------------------------------------------------------------------------------

.equ ITCM_LOAD,	(1<<19)
.equ ITCM_ENABLE,	(1<<18)
.equ DTCM_LOAD,	(1<<17)
.equ DTCM_ENABLE,	(1<<16)
.equ DISABLE_TBIT,	(1<<15)
.equ ROUND_ROBIN,	(1<<14)
.equ ALT_VECTORS,	(1<<13)
.equ ICACHE_ENABLE,	(1<<12)
.equ BIG_ENDIAN,	(1<<7)
.equ DCACHE_ENABLE,	(1<<2)
.equ PROTECT_ENABLE,	(1<<0)

.equ PAGE_16K,	(0b01101 << 1)

@---------------------------------------------------------------------------------
	.section .init
	.global __vector_reset
@---------------------------------------------------------------------------------
	# align x = align to 2^x byte
	.align	4
	.arm
@---------------------------------------------------------------------------------
__vector_reset:
@---------------------------------------------------------------------------------
	mov	r0, #0x04000000			@ IME = 0;
	str	r0, [r0, #0x208]
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	@---------------------------------------------------------------------------------
	@ Protection Unit Setup added by Sasq
	@---------------------------------------------------------------------------------
	@ Disable cache
	mov	r0, #0
	mcr	p15, 0, r0, c7, c5, 0		@ Instruction cache
	mcr	p15, 0, r0, c7, c6, 0		@ Data cache

	@ Wait for write buffer to empty 
	mcr	p15, 0, r0, c7, c10, 4

	ldr	r0, =__dtcm_start
	orr	r0,r0,#0x0a
	mcr	p15, 0, r0, c9, c1,0		@ DTCM base = __dtcm_start, size = 16 KB

	mov r0,#0x20
	mcr	p15, 0, r0, c9, c1,1		@ ITCM base = 0 , size = 32 MB

	@-------------------------------------------------------------------------
	@ Region 4 - DTCM
	@-------------------------------------------------------------------------
	ldr	r0,=__dtcm_start
	orr	r0,r0,#(PAGE_16K | 1)
	mcr	p15, 0, r0, c6, c4, 0
	
	@-------------------------------------------------------------------------
	@ Enable ICache, DCache, ITCM & DTCM
	@-------------------------------------------------------------------------
	mrc	p15, 0, r0, c1, c0, 0
	ldr	r1,= ITCM_ENABLE | DTCM_ENABLE | ICACHE_ENABLE | DCACHE_ENABLE | PROTECT_ENABLE
	orr	r0,r0,r1
	mcr	p15, 0, r0, c1, c0, 0
	
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

	mov	r0, #0x12		@ Switch to IRQ Mode
	msr	cpsr, r0
	ldr	sp, =__sp_irq		@ Set IRQ stack
	
	mov	r0, #0x11		@ Switch to FIQ Mode
	msr	cpsr, r0
	ldr	sp, =__sp_fiq		@ Set FIQ stack
	
	mov	r0, #0x13		@ Switch to SVC Mode
	msr	cpsr, r0
	ldr	sp, =__sp_svc		@ Set SVC stack	

	mov	r0, #0x1f		@ Switch to System Mode
	msr	cpsr, r0
	ldr	sp, =__sp_sys		@ Set user stack
	
@	mov	r0, #0x13		@ Switch to SVC Mode
@	msr	cpsr, r0
@	ldr	sp, =__sp_svc		@ Set SVC stack		

	
	ldr	r1, =__bss_start__	@ Clear BSS section
	ldr	r3, =__bss_end__
	mov r2, #0x0
	cmp r1, r3
	beq _init_IF_and_IE
_clear_bss:
	str r2,[r1,#4]!
	cmp r1, r3
	bne _clear_bss
   	
_init_IF_and_IE:
	mov r0, #~0x0
	mov r2, #0x0
	mov r1, #0x04000000
	str r0, [r1, #0x214]		@ REG_IF = ~0;	
	str r2, [r1, #0x210]		@ REG_IE = 0;
	
_set_irq_handler:
	ldr r0, =__vector_irq
	ldr r1, =__dtcm_start+0x3ffc 
	str r0, [r1]
	
@	ldr r0, =0x1000
@	ldr r1, =__dtcm_start+0x3ff8 @__irq_flags
@	str r0, [r1]
	
_enable_IME_and_CPSRirq:
	mrs r0, cpsr
	bic r0, r0, #0x80
	msr cpsr, r0
	mov r1, #1
	mov	r0, #0x04000000			@ IME = 1;
	str	r1, [r0, #0x208]
	
_set_main_argc_argv:
	# argc=0 and arg=NULL
	mov r0, #0
	mov r1, r0

	# Jump to the main
	bl  gcMain

	# Just loop now (the program finished)
__loop:
	b   __loop
	
_vector_irq1:			.word	__vector_irq
