OUTPUT_FORMAT("elf32-littlearm", "elf32-bigarm", "elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(_start)

MEMORY 
{
	rom		: ORIGIN = 0x08000000, LENGTH = 32M
	ewram	: ORIGIN = 0x02000000, LENGTH = 4M - 4k
	dtcm	: ORIGIN = 0x0b000000, LENGTH = 16K
	vectors	: ORIGIN = 0x01000000, LENGTH = 256
	itcm	: ORIGIN = 0x01000100, LENGTH = 32K - 256
}

__rom_start		=	ORIGIN(rom);
__vectors_start	=	ORIGIN(vectors);
__itcm_start	=	ORIGIN(itcm);
__ewram_start	=	ORIGIN(ewram);
__ewram_end		=	ORIGIN(ewram) + LENGTH(ewram);
//__eheap_end		=	ORIGIN(ewram) + LENGTH(ewram);
__dtcm_start	=	ORIGIN(dtcm);
__dtcm_top		=	ORIGIN(dtcm) + LENGTH(dtcm);
__irq_flags		=	__dtcm_top - 0x08;
__irq_vector	=	__dtcm_top - 0x04;

__sp_svc	=	__dtcm_top - 0x100;
__sp_irq	=	__sp_svc - 0x100;
__sp_sys	=	__sp_irq - 0x100;
__sp_fiq	=	__sp_sys - 0x100;

//__sp_sys	=	0x2400000-4;
SECTIONS
{
	.text __ewram_start : AT (__ewram_start)
	{
		*(.startup)
		*(.init)
		*(.text)
		. = ALIGN(4);  /* REQUIRED. LD is flaky without it. */
	} >ewram = 0xff
	
	.rodata :
	{
		*(.rodata)
		. = ALIGN(4);   /* REQUIRED. LD is flaky without it. */
	} >ewram = 0xff
	
	__data_lma = . ;
	
	.data : AT (__data_lma)
	{
		//__data_start = ABSOLUTE(.);
		*(.data)
		. = ALIGN(4);
	} >ewram = 0xff
	
	__data_end = . ;
	
	//__bss_start__ = .;
	__bss_start__ = __data_lma + SIZEOF(.data) ;
	.bss ALIGN(4) : AT (__bss_start__)
	{
		//__bss_start = ABSOLUTE(.);
		*(.bss)
		. = ALIGN(4);
	} >ewram /*= 0xff*/
	__bss_end__ = .;
}
