

	.section .text

	.extern	irqTable
	.code 32

	.global	IntrMain, __cpsr_mask
@---------------------------------------------------------------------------------
IntrMain:
@---------------------------------------------------------------------------------
	mov	r12, #0x4000000		@ REG_BASE

	ldr	r1, [r12, #0x208]	@ r1 = IME
	cmp	r1, #0
	bxeq	lr
	
	mov	r0, #0
	str	r0, [r12, #0x208]	@ disable IME
	mrs	r0, spsr
	stmfd	sp!, {r0-r1,r12,lr}	@ {spsr, IME, REG_BASE, lr_irq}

	add	r12, r12, #0x210
	ldmia	r12, {r1,r2} @@@ r1=IF, r2=IE
	ands	r1, r1, r2   @@@ r1 = IF & IE
	ldr	r0, =__irq_flags	@ defined by linker script  @@@ r0 = WAIT_FLAGS
	ldr	r2, =irqTable		@@@ r2 = irqTable

setflags:
	ldr	r3,[r0]   @@@ r3 = WAIT_FLAGS
	orr	r3,r3,r1  @@@ r3 = WAIT_FLAGS | (IF & IE)
	str	r3,[r0]   @@@ WAIT_FLAGS = WAIT_FLAGS | (IF & IE)

@---------------------------------------------------------------------------------
findIRQ:
@---------------------------------------------------------------------------------
	ldr r0, [r2, #4]   @@@ r0 = irqTable.mask(irqTable+4)
	cmp	r0, #0         @@@ cmp irqTable+4,0
	beq	no_handler     @@@ if(mask == 0) then goto no_handler
	ands	r0, r0, r1 @@@ r0 = mask & (IF & IE)
	bne	jump_intr	   @@@ if(!(mask & (IF & IE))) then goto jump_intr
	add	r2, r2, #8	   @@@ r2 = irqTable+1
	b	findIRQ        @@@ goto findIRQ

@---------------------------------------------------------------------------------
no_handler:
@---------------------------------------------------------------------------------
	str	r1, [r12, #4]	@ IF Clear @@@ IF = 0
	ldmfd   sp!, {r0-r1,r12,lr}	@ {spsr, IME, REG_BASE, lr_irq}
	str	r1, [r12, #0x208]	@ restore REG_IME  @@@ IME = ԭIME
	mov	pc,lr    @@@ return lr_irq : continue

@---------------------------------------------------------------------------------
jump_intr:
@---------------------------------------------------------------------------------
	ldr	r1, [r2]		@ user IRQ handler address  @@@ r1 = irqTable.handler()
	cmp	r1, #0										@@@ cmp handler, 0
	bne	got_handler									@@@ if(handler != 0) then goto got_handler
	mov	r1, r0										@@@ r1 = mask & (IF & IE)
	b	no_handler									@@@ goto no_handler
@---------------------------------------------------------------------------------
got_handler:
@---------------------------------------------------------------------------------

	str	r0, [r12, #4]	@ IF Clear      @@@ IF = 0

	mrs	r2, cpsr						@@@ r2 = cpsr
	mov	r3, r2							@@@ r3 = cpsr
	bic	r3, r3, #0xdf		@ \__		@@@ r3 = ~(0xdf) & cpsr
	orr	r3, r3, #0x13		@ /  --> Enable IRQ & FIQ. Set CPU mode to System.
	msr	cpsr,r3							@@@ cpsr = Enable IRQ & FIQ. Set CPU mode to System.

	
	push	{r2,lr}						@@@ r2 = cpsr_irq
	
@	mov r4, #1
@	mov r5, #0x4000000
@	str r4, [r4,#0x208]
	
	adr	lr, IntrRet						@@@ ???
	bx	r1								@@@ goto irqTable.handler()

@---------------------------------------------------------------------------------
IntrRet:
@---------------------------------------------------------------------------------
	mov	r12, #0x4000000		@ REG_BASE
	str	r12, [r12, #0x208]	@ disable IME
	pop	{r2,lr}

	msr	cpsr, r2			@ cpsr_sys  = cpsr_irq : л irq ģʽ

	ldmfd   sp!, {r0-r1,r12,lr}	@ {spsr, IME, REG_BASE, lr_irq}
	msr	spsr, r0		@ restore spsr
	str	r1, [r12, #0x208]	@ restore REG_IME
	mov	pc,lr

	.pool
	.end
