#include "headfile.h"
#include "platform.h"
#include "macro.h"


typedef void (* VoidFn)(void);
//typedef void (* IntFn)(void);
void IntrMain();	// Prototype for assembly interrupt dispatcher

extern VoidFn	__irq_vector[];
#define IRQ_HANDLER             *(__irq_vector)

extern void _close_cpsr();
extern void _open_cpsr();

void enable_irq(void){
	asm volatile (
		"mrs r4,cpsr\n\t"
		"bic r4,r4,#0x80\n\t"
		"msr cpsr,r4\n\t"
		"mov r4, #1\n\t"
		"mov r5, #0x4000000\n\t"
		"str r4, [r5,#0x208]\n\t"
		:::"r4","r5"
	);
}

void disable_irq(void){
	asm volatile (
		"mrs r4,cpsr\n\t"
		"orr r4,r4,#0x80\n\t"
		"msr cpsr,r4\n\t"
		"mov r4, #0x4000000\n\t"
		"str r4, [r4, #0x208]\n\t"
		:::"r4"
	);
}


void swi_wait_for_Vblank()
{
	asm(
		"swi	0x06\n"
		);
}

static inline int enterCriticalSection() {
	int oldIME = REG_IME;
	REG_IME = 0;
	return oldIME;
}

static inline void leaveCriticalSection(int oldIME) {
	REG_IME = oldIME;
}

//! maximum number of interrupts.
#define MAX_INTERRUPTS  25
struct IntTable
{
	IntFn handler; 
	unsigned int mask;
}irqTable[MAX_INTERRUPTS];

void irqDummy(void) {}


//---------------------------------------------------------------------------------
void irqEnable(unsigned int irq) 
{
//---------------------------------------------------------------------------------
	int oldIME = enterCriticalSection();
	if (irq & IRQ_VBLANK)
		REG_DISPSTAT |= DISP_VBLANK_IRQ ;
	if (irq & IRQ_HBLANK)
		REG_DISPSTAT |= DISP_HBLANK_IRQ ;
	if (irq & IRQ_VCOUNT)
		REG_DISPSTAT |= DISP_YTRIGGER_IRQ;
	if(irq & IRQ_IPC_SYNC)
		REG_IPC_SYNC |= IPC_SYNC_IRQ_ENABLE;

	REG_IE |= irq;
	leaveCriticalSection(oldIME);
}

//---------------------------------------------------------------------------------
static void __irqSet(unsigned int mask, IntFn handler, struct IntTable irqTable[] ) 
{
//---------------------------------------------------------------------------------
	if (!mask) return;

	int i;

	for	(i=0;i<MAX_INTERRUPTS;i++)
		if	(!irqTable[i].mask || irqTable[i].mask == mask) break;

	if ( i == MAX_INTERRUPTS ) return;

	irqTable[i].handler	= handler;
	irqTable[i].mask	= mask;
}

//---------------------------------------------------------------------------------
void irqSet(unsigned int mask, IntFn handler) 
{
//------------------------------------------void __vector_irq();---------------------------------------
	int oldIME = enterCriticalSection();
	__irqSet(mask,handler,irqTable);
	if(mask & IRQ_VBLANK)
		REG_DISPSTAT |= DISP_VBLANK_IRQ ;
	if(mask & IRQ_HBLANK)
		REG_DISPSTAT |= DISP_HBLANK_IRQ ;
	if(mask & IRQ_IPC_SYNC)
		REG_IPC_SYNC |= IPC_SYNC_IRQ_ENABLE;
	leaveCriticalSection(oldIME);
}
void __vector_irq();
//---------------------------------------------------------------------------------
void irqInit() 
{
//---------------------------------------------------------------------------------
	int i;

	REG_IE	= 0;			// disable all interrupts

	// Set all interrupts to dummy functions.
	for(i = 0; i < MAX_INTERRUPTS; i ++)
	{
		irqTable[i].handler = irqDummy;
		irqTable[i].mask = 0;
	}

	IRQ_HANDLER = IntrMain;

	REG_IF	= IRQ_ALL;		// clear all pending interrupts
	REG_IME = 1;			// enable global interrupt

}

void vblank_irq_handler()
{
	printk("++");
}

void common_irq_handler()
{
/*
	//enable_irq();
	if(REG_IF & IRQ_VBLANK)
	{
		printk("VBLANK  ");
		WAIT_FLAGS |= IRQ_VBLANK;
		REG_IF |= IRQ_VBLANK;
	}
	if(REG_IF & IRQ_KEYS)
	{
		printk("KEY  ");
		WAIT_FLAGS |= IRQ_KEYS;
		REG_IF |= IRQ_KEYS;	
	}	
	//disable_irq();
*/	
	
//	enable_irq();
	if(REG_KEYINPUT & 0x1)
		printk("A");
	if(REG_KEYINPUT & 0x2)
		printk("B");
//	disable_irq();
	return;
}

