#include "platform.h"
#include "driver.h"
#include "io_scsd.h"
#include "dldi.h"
#include "headfile.h"

#define NDS
#define ARM9

#ifndef SUPPORT_SCSD
	#define SUPPORT_SCSD
#endif

#ifndef SUPPORT_SCCF
	#define SUPPORT_SCCF
#endif

LPIO_INTERFACE active_interface = 0;

#define WAIT_CR (*(volatile unsigned short*)0x04000204)

/*
bool disc_setDsSlotInterface (void)
{
#ifdef ARM9
	WAIT_CR &= ~(1<<11);
#endif
#ifdef ARM7
	WAIT_CR |= (1<<11);
#endif

#ifdef SUPPORT_NMMC
	// check if we have a Neoflash MK2 / MK3 plugged in
	active_interface = NMMC_GetInterface() ;
	if (active_interface->fn_StartUp())
	{
		// set Neoflash MK2 / MK3 as default IO
		return true ;
	} ;
#endif

	return false;
}
*/

//#define WAIT_FLAGS		(*(volatile unsigned int*)0x0b003ffc)


bool disc_setGbaSlotInterface (void)
{
#ifdef ARM9
	WAIT_CR &= ~(1<<11);
#endif
#ifdef ARM7
	WAIT_CR |= (1<<11);
#endif

	// If running on an NDS, make sure the correct CPU can access
	// the GBA cart. First implemented by SaTa.
#ifdef NDS
 #ifdef ARM9
	WAIT_CR &= ~(0x8080);
 #endif
 #ifdef ARM7
	WAIT_CR |= (0x8080);
 #endif
#endif
/*
// check if we have a valid DLDI driver
active_interface = DLDI_GetInterface() ;
if (active_interface->fn_StartUp())
{
	// set the DLDI driver as the default IO
	return true ;
} ;
*/

#ifdef SUPPORT_SCSD
	// check if we have a SuperCard SD plugged in
	printk("init SCSD......\n");
	active_interface = SCSD_GetInterface() ;
	if (active_interface->fn_StartUp())
	{
		printk("SCSD OK\n");
		// set SC SD as default IO
		return true ;
	} ;
#endif


	printk("init SCSD ERROR!!!\n");
	return false;
}

bool init_sccd()
{
	if (active_interface != 0) 
	{
		return true;
	}
	
	if (disc_setGbaSlotInterface()) 
	{
		return true;
	}

	// could not find a working IO Interface
	active_interface = 0 ;
	
	return false ;
}

bool ReadSectors(unsigned int sector, unsigned char numSecs, void* buffer) 
{
	if (active_interface) 
		return active_interface->fn_ReadSectors(sector,numSecs,buffer) ;
	return false ;
} 

bool initall(void* buffer)
{
printk("1111\n");
	if (!init_sccd())
	{
		printk("init_sccd ERROR\n");
		return (false);
	}
	
	if ( !ReadSectors(0,1, buffer)) 
	{
		printk("ReadSectors ERROR\n");	
		return false;
	}
	printk("2222\n");
	return true;
}

