/*
	io_dldi.h 

	Reserved space for new drivers
	
	This software is completely free. No warranty is provided.
	If you use it, please give me credit and email me about your
	project at chishm@hotmail.com

	See gba_nds_fat.txt for help and license details.
*/

#ifndef IO_DLDI_H
#define IO_DLDI_H

// 'DLDI'
#define DEVICE_TYPE_DLDI 0x49444C44

#include "driver.h"
#define WAIT_CR (*(volatile unsigned short*)0x04000204)

	#define ARM9_OWNS_SRAM (1<<15)
	#define ARM9_OWNS_CARD (1<<11)
	#define ARM9_OWNS_ROM  (1<<7)


extern IO_INTERFACE _io_dldi;

// export interface
static inline LPIO_INTERFACE DLDI_GetInterface(void) 
{
//#ifdef NDS
	WAIT_CR &= ~(ARM9_OWNS_ROM | ARM9_OWNS_CARD);
//#endif // defined NDS
	return &_io_dldi;
}

#endif	// define IO_DLDI_H

