
.equ DISABLE_IRQ,0x80
.equ DISABLE_FIQ,0x40
.equ SYS_MOD,0x1f
.equ IRQ_MOD,0x12
.equ FIQ_MOD,0x11
.equ SVC_MOD,0x13
.equ ABT_MOD,0x17
.equ UND_MOD,0x1b
.equ MOD_MASK,0x1f

@.extern common_irq_handler

        @msr     cpsr_c,#(DISABLE_FIQ|DISABLE_IRQ|SYS_MOD)
        @msr     cpsr_c,#(DISABLE_FIQ|DISABLE_IRQ|IRQ_MOD)
        
.macro CHANGE_TO_SVC

        msr     cpsr,#(SVC_MOD)
.endm

.macro CHANGE_TO_IRQ
        
        msr     cpsr,#(IRQ_MOD)
.endm



.global	__vector_undefined
.global	__vector_swi
.global	__vector_prefetch_abort
.global	__vector_data_abort
.global	__vector_reserved
.global	__vector_irq
.global	__vector_fiq

.section .text,"ax"
.code 32
.align 2


__vector_undefined:
	nop
__vector_swi:
	nop
__vector_prefetch_abort:	
	nop
__vector_data_abort:
	nop
__vector_reserved:
	nop
__vector_irq:
@	mov	r12, #0x4000000		@ REG_BASE
@	ldr	r1, [r12, #0x208]	@ r1 = IME
@	cmp	r1, #0
@	bxeq	lr
	
@	mov	r0, #0
@	str	r0, [r12, #0x208]	@ disable IME
	
	sub r14,r14,#4
	stmfd r13!,{r14}
	mrs r14,spsr
	stmfd r13!,{r14}

@	CHANGE_TO_SVC
	stmfd r13!,{r0-r12}
	bl common_irq_handler
	ldmfd r13!,{r0-r12}
@	CHANGE_TO_IRQ
	
@	mov	r0, #1
@	mov r1, #0x4000000
@	str	r0, [r1, #0x208]	@ enable IME
	
	ldmfd r13!,{r14}
	msr spsr,r14
	ldmfd r13!,{pc}^


__vector_fiq:
	nop
