// log.cpp: implementation of the CLog class.
//
//////////////////////////////////////////////////////////////////////

#include "log.h"
#include "config.h"
#include <stdio.h>
#include <cstdarg>
#include <string.h>
#include "platform.h"

#ifdef NMGB_PLATFORM_WIN32
#include <ctime>
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#if NMGB_DEBUG_ON
	CLog g_log("log.html");

/*
	#define dgbmsg(fmt,...) \
	
	  printf(fmt,__VA_ARGS__)
*/
#endif


#define NMGB_NO_TIME	"NoTime"

CLog::CLog()
{

}

CLog::CLog(const char * szFilename)
{
	Init(szFilename);
}


CLog::~CLog()
{

}

bool CLog::Init(const char * szFile)
{
	char caTime[32];
	char caDate[32];
	FILE * f = fopen(szFile, "wt");
	if(!f)
		return false;
	
	fprintf(f, "<HTML>\n<HEAD><TITLE>Nomad3D Log</TITLE></HEAD>\n<BODY BGCOLOR = \"#000000\">\n");
#ifdef NMGB_PLATFORM_WIN32
	_strtime(caTime);
	_strdate(caDate);
#else
	strcpy(caDate, NMGB_NO_TIME);
	strcpy(caTime, NMGB_NO_TIME);
#endif
	fprintf(f, "<FONT COLOR = \"#FFFFFF\">Log Started at %s on %s</FONT><BR><BR>\n", caTime, caDate);
	fprintf(f, "</BODY></HTML>");
	fclose(f);
	m_szFilename = (char *)szFile;
	
	return true;
}

void CLog::Write(const char * szColor, const char * szFmt, ...)
{
	char caString[1024];
	char caTime[32];
	
	va_list va;
	va_start(va, szFmt);
	vsprintf(caString, szFmt, va);
	va_end(va);
#ifdef NMGB_PLATFORM_WIN32
	_strtime(caTime);
#else
	strcpy(caTime, NMGB_NO_TIME);
#endif
	
	FILE * f = fopen(m_szFilename, "r+");
	if(!f)
		return;
	
	fseek(f, -14, SEEK_END);
	fprintf(f, "<FONT COLOR = \"%s\">%s&nbsp;&nbsp;&nbsp;&nbsp;%s</FONT><BR>\n", szColor, caTime, caString);
	fprintf(f, "</BODY></HTML>");
	fclose(f);
}