// interrupt.h: interface for the CInterrupt class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_INTERRUPT_H__40002922_0D5B_4F2C_B614_78F9CDCF6D4D__INCLUDED_)
#define AFX_INTERRUPT_H__40002922_0D5B_4F2C_B614_78F9CDCF6D4D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CMemory;
class CZ80m;
class CGBMachine;
class CInput;

class CInterrupt  
{
	friend class CZ80m;
public:
	CInterrupt();
	virtual ~CInterrupt();
public:
	void SetMachine(CGBMachine* pMachine);
	void SetCPU(CZ80m* pCPU);
	void SetMemory(CMemory* pMemory);
	void SetInput(CInput* pInput);

	int HandleInterrupts();
	void InterruptsInit(void);
	void HandleClock(void);
	void CheckStatInterrupt(void);
	void SetInterrupt(int flag);

	//int CurrentScanLine;
protected:
	CMemory*	m_pMemory;
	CZ80m*		m_pCPU;
	CGBMachine*	m_pMachine;
	CInput*		m_pInput;
	int			m_nVBlankDelayClks;

	int			m_nTimeFreq[4];
};

#endif // !defined(AFX_INTERRUPT_H__40002922_0D5B_4F2C_B614_78F9CDCF6D4D__INCLUDED_)
