#ifndef NMGB_CONFIG_H
#define NMGB_CONFIG_H

#include <stdio.h>

#define NMGB_PLATFORM_3DS
//#define NMGB_PLATFORM_WIN32
//#define NMGB_PLATFORM_UNIX
//#define NMGB_PLATFORM_NDS

#define NMGB_DEBUG_ON			0

#define NMGB_INTEGRATE_ROM		1
#define NMGB_INTEGRATE_INNERROM	0

#define NMGB_LOAD_INNERROM		0

#if ((NMGB_INTEGRATE_INNERROM) && (NMGB_LOAD_INNERROM))
extern const unsigned char DMG_ROM_bin[];
#endif


#if (NMGB_INTEGRATE_INNERROM)
#define NMGB_INNERROM_DATA		(char*)DMG_ROM_bin
#else
#define NMGB_INNERROM_DATA		NULL
#endif


//#define BOOT_ROM_FOLDER "boot"
#define DMG_ROM_FILENAME "dmg_rom.bin"
#define MGB_ROM_FILENAME "mgb_rom.bin"
#define SGB_ROM_FILENAME "sgb_rom.bin"
#define SGB2_ROM_FILENAME "sgb2_rom.bin"
#define CGB_ROM_FILENAME "cgb_rom.bin"
#define AGB_ROM_FILENAME "agb_rom.bin"

#define ENABLE_GB	0x01
#define ENABLE_GBC	0x02
#define ENABLE_SGB	0x04

#define VBLANK_DELAY_CLKS	24

//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
typedef enum _tagEHWType
{
	HW_AUTO,
	HW_GB,
	HW_GBP,
	HW_GBC,
	HW_SGB,
	HW_SGB2,
	HW_GBA
} EHWType;


class CConfigInfo
{
public:
	CConfigInfo()
	{
		m_sInnerRomFile = NMGB_INNERROM_DATA;
		m_bLoadInnerROM = NMGB_LOAD_INNERROM;

		m_HWType = HW_GB;

		m_sROMFile = 0;
	}
public:
	char*	m_sInnerRomFile;
	bool	m_bLoadInnerROM;
	EHWType	m_HWType;
	const char*	m_sROMFile;
};

extern CConfigInfo g_configinfo;

#endif //NMGB_CONFIG_H

