#ifndef NOMANDGB_INPUT_H
#define NOMANDGB_INPUT_H

#include "platform.h"

extern u32			g_Key[4];

class CInput
{
public:
	CInput()
	{
		for(int i=0; i<4; i++)
			m_nKey[4] = 0;
	}
public:
	inline void SetKey(int n, u32 key)
	{
		m_nKey[n]=key;
	}
// 	inline void AddKey(u32 key)
// 	{
// 		m_nKey[0] |= key;
// 	}
	//////////////////////////////////////////////////////////////////////////
	//
	inline void SetKeyRegister(u8& p1_reg)
	{
		u32 result = 0;
		m_nKey[0] = g_Key[0];
		u32 Keys = m_nKey[0];
		if((p1_reg & (1<<5)) == 0) //A-B-SEL-STA
		{
			result |= (Keys & NMGB_KEY_A) ? JOY_A : 0;
			result |= (Keys & NMGB_KEY_B) ? JOY_B : 0;
			result |= (Keys & NMGB_KEY_SELECT) ? JOY_SELECT : 0;
			result |= (Keys & NMGB_KEY_START) ? JOY_START : 0;
		}
		if((p1_reg & (1<<4)) == 0) //PAD
		{
			result |= (Keys & NMGB_KEY_RIGHT) ? JOY_RIGHT : 0;
			result |= (Keys & NMGB_KEY_LEFT) ? JOY_LEFT : 0;
			result |= (Keys & NMGB_KEY_UP) ? JOY_UP : 0;
			result |= (Keys & NMGB_KEY_DOWN) ? JOY_DOWN : 0;
		}

		result = (~result) & 0x0F;
		result |= p1_reg & 0xF0;
		result |= 0xC0;

		p1_reg = result;
	}

	inline bool HasKeydown(u8& p1_reg)
	{
		u32 result = 0;
		int Keys = m_nKey[0];

		if((p1_reg & (1<<5)) == 0) //A-B-SEL-STA
			result |= Keys & (NMGB_KEY_A|NMGB_KEY_B|NMGB_KEY_SELECT|NMGB_KEY_START);
		if((p1_reg & (1<<4)) == 0) //PAD
			result |= Keys & (NMGB_KEY_UP|NMGB_KEY_DOWN|NMGB_KEY_LEFT|NMGB_KEY_RIGHT);

		return (result != 0);
	}

protected:
	u32 m_nKey[4];
};


#endif //NOMANDGB_INPUT_H
